/* ************************************************************************** */
/* Example of a syndication feed reader using the Project Rome API            */
/* current version of Rome: rome1.0.jar            https://rome.dev.java.net/ */
/* You need to implement this API plus the JDOM API                           */
/* jdom.jar  ,   you can find this at               https://jdom.org/         */
/* Parts of this example are taken from the PRome Web Page tutorials          */
/* https://rome.dev.java.net/  author:   Alejandro Abdelnur                   */
/*                                                                            */
/* This class prints a retrieved feed with its tree structure to the system   */
/* created by Martin Stoppacher       date:  26.12.2009                       */
/* license:    LGPL 3.0                                                       */
/*             (Lesser Gnu Public License version 3.0),                       */
/*             cf. <http://www.gnu.org/licenses/lgpl.html>                    */
/* ************************************************************************** */
import java.net.URL;
/*  Class URL represents a Uniform Resource Locator,                          */
/*  a pointer to a "resource" on the World Wide Web                           */
import java.io.InputStreamReader;
/*  An InputStreamReader is a bridge from byte streams to character streams   */
import java.io.Writer;
/* Abstract class for writing to character streams                            */
import com.sun.syndication.feed.synd.SyndFeed;
/* This is the Bean interface for all types of feeds.                         */
import com.sun.syndication.io.SyndFeedInput;
/* Parses an XML document (File, InputStream, Reader, W3C SAX InputSource, W3C*/
/* DOM Document or JDom DOcument) into an WireFeed (RSS/Atom).                */
import com.sun.syndication.io.SyndFeedOutput;
/* Generates an XML document(String, File, OutputStream, Writer,              */
/* W3C DOM document or JDOM document)out of an SyndFeedImpl                   */
import com.sun.syndication.io.XmlReader;
/* Character stream that handles (or at least attemtps to) all the necessary  */
/* Voodo to figure out the charset encoding of the XML document within        */
/* the stream.                                                                */

public class 3_FeedReader_with_output {

    public static void main(String[] args) {
    	String feedType = "http://rss.orf.at/fm4.xml";
    	//String feedType = args[1];    /* e.g. you can also use the args array */
    	String outputType = "rss_2.0";
    	//String outputType = args[0];  /* e.g. you can also use the args array */
        boolean ok = false;
            try {          	
                URL feedUrl = new URL(feedType);

                SyndFeedInput input = new SyndFeedInput();
                SyndFeed feed = input.build(new XmlReader(feedUrl));
                feed.setFeedType(outputType); 
                /*    feed converter, set the type to the chosen outputType   */
                
                SyndFeedOutput output = new SyndFeedOutput();  
                /*    Tree Output of the feed                                 */
                output.output(feed,new PrintWriter(System.out)); 
                
                //System.out.println(feed);
                               
                ok = true;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                System.out.println("ERROR: "+ex.getMessage());
            }

        if (!ok) {
            System.out.println();
            System.out.println("FeedReader reads and prints any RSS/Atom feed type.");
            System.out.println();
        }
    }
}